/*jslint node: true, nomen: true, unparam: true */
/*global jquery, $, _, define, Marionette, jqm, describe, it, expect, beforeEach, spyOn */

define([ 'Portal', 'backbone', 'marionette', 'jquery', 'underscore', 'jquerymobile',
    'hbs!applets/wound-care-applet/core/extensions/list-generator/core/views/appletLayout',
    'applets/wound-care-applet/core/extensions/list-generator/Model',
    'applets/wound-care-applet/core/extensions/list-generator/core/views/AppletTitleView',
    'applets/wound-care-applet/core/extensions/list-generator/core/views/loading/LoadingView',
    'applets/wound-care-applet/core/extensions/list-generator/core/views/wards/WardListView',
    'applets/wound-care-applet/core/extensions/list-generator/core/views/SimpleListView',
    'applets/wound-care-applet/core/extensions/list-generator/core/views/WCListView',
    'applets/wound-care-applet/core/extensions/list-generator/core/views/patients/PatientListView',
    'applets/wound-care-applet/core/extensions/list-generator/core/views/confirmation/ConfirmationView' ],
    function (Portal, Backbone, Marionette, $, _, jqm, template, Model, AppletTitleView, LoadingView) {
        'use strict';
			return Portal.module('ListGenerator', function (ListGenerator, Portal, Backbone, Marionette, $, _, template) {
            ListGenerator.Layout = Backbone.Marionette.Layout.extend({
                model: ListGenerator.model,
                id: "search",
							className: "applet scrollable wc-search",
                template: template,
                regions: {
                    titleRegion: 'div[data-role=header] h2',
                    //navBarRegion: '#search-type-menu',
                    primaryFilterRegion: '#primary-search-filter',
                    secondaryFilterRegion: '#secondary-search-filter'
                },
                events: {
                    'pageshow': '_onPageShow',
                    'focus #secondary-search-filter input': 'hidePrimarySearchList'
                },
                initialize: function() {
                    var self = this;

                    // this.searchViews contains functions for creating views
                    this.initializeSearchViews(this.model.get('configTypes'));

                    this.confirmationPopup = new ListGenerator.ConfirmationView({ model: ListGenerator.model.get('patient') });

                    this.listenTo(self.model, 'change:searchType', function() {
                        if ( typeof self.primaryFilterRegion !== "undefined" && typeof self.primaryFilterRegion.currentView !== "undefined" ) {
                            self.updateView();
                        }
                    });
                },
                onRender: function() {
                    var fragment = ListGenerator.model.get('searchType');

									Portal.WoundCareApplet.vent.trigger("show");
                    this.updateView();
                    //this.navBarRegion.show( new ListGenerator.NavBarView() );
                    this.titleRegion.show( new AppletTitleView({model:ListGenerator.model}) );

                    this.$el.find('a[href=#search-' + fragment + ']').addClass('ui-btn-active');
                },
                _onPageShow: function() {
                    this.primaryFilterRegion.$el.find('.ui-input-search input').focus();
                },
                onClose: function() {
                    var config = this.model.get('configTypes'),
                        confirmationEl = '#' + this.confirmationPopup.id;
                    this.stopListening();
                    this.off();
                    if (config.clinics) {
                        this.stopListening(this.model.searches.get('clinics'));
                    }
                    if (config.wards) {
                        this.stopListening(this.model.searches.get('wards'));
                    }
                    // used for confirmation
                    $(confirmationEl).popup('destroy');
                    $(confirmationEl).remove();
                },
                updateView: function() {
                    var type = this.model.get('searchType'),
                        config = this.model.get('configTypes');

                    if (typeof config[type] !== 'undefined' && config[type]) {
                        switch (type) {
                            case 'clinics':
                            case 'wards':
                                this.primaryFilterRegion.show( this.searchViews[type].locationList() );
                                this.toggleSecondaryFilter(type);
                                // set focus
                                if (typeof this.model.searches.get(type) !== "undefined" && this.model.searches.get(type).get('location') !== '') {
                                    this.secondaryFilterRegion.$el.find('.ui-input-search input').focus();
                                } else {
                                    this.primaryFilterRegion.$el.find('.ui-input-search input').focus();
                                }
                                break;
                            case 'recent':
                            //case 'my-list':
                            //    break;
                            case 'patients':
                                this.primaryFilterRegion.show( this.searchViews[type].patientList() );
                                this.hideSecondaryFilter();
                                // set focus
                                this.primaryFilterRegion.$el.find('.ui-input-search input').focus();
                                break;
                            case 'wc-list':
                                this.primaryFilterRegion.show( this.searchViews[type].locationList() );
                                this.toggleSecondaryFilter(type);
                                // set focus
                                if (typeof this.model.searches.get(type) !== "undefined" && this.model.searches.get(type).get('location') !== undefined && this.model.searches.get(type).get('location') !== '') {
                                    this.secondaryFilterRegion.$el.find('.ui-input-search input').focus();
                                } else {
                                    this.primaryFilterRegion.$el.find('.ui-input-search input').focus();
                                }
                                break;
                        }
                    } else {
                        console.log("Search Applet error: '" + type + "' is not a valid search type; check if '" + type + "' was passed in option.types");
                    }
                },
                toggleSecondaryFilter: function (type) {
                    var search = this.model.searches.get(type);

                    if ( typeof search !== 'undefined' && search.get('location') !== undefined && search.get('location') !== '' ) {
                        this.showSecondaryFilter();
                    } else {
                        this.hideSecondaryFilter();
                    }
                },
                showSecondaryFilter: function () {
                    var type = this.model.get('searchType');

                    this.secondaryFilterRegion.show( this.searchViews[type].patientList() );
                },
                hideSecondaryFilter: function () {
                    this.secondaryFilterRegion.close();
                },
                hidePrimarySearchList: function(){
                    $("#primary-search-filter .ui-accessible-autocomplete").trigger("hide");
                },
                initializeSearchViews: function (config) {
                    this.searchViews = {};

                    this._addPatientSearchView(config.patients);
                    this._addClinicSearchView(config.clinics);
                    this._addWardSearchView(config.wards);
                    this._addRecentPatientSearchView(config.recent);
                    this._woundCareStuff(config['wc-list']);

                    //this._addMyListSearchView(config.['my-list']);
                },
                _woundCareStuff: function(isConfigured){
                    var self = this,
                        getWardListView = function() {
                            return new ListGenerator.WardListView({
                                model: self.model.searches.get('wc-list'),
                                collection: self.model.searches.get('wc-list').get('locationCollection')
                            });
                        };

                    if (isConfigured) {
                        this._addLocationSearchView('wc-list', getWardListView, function(){
                            return new ListGenerator.WCListView({
                                model: self.model.searches.get('wc-list'),
                                collection: self.model.searches.get('wc-list').get('patientCollection')
                            });
                        });
                    }
                },
                _addPatientSearchView: function (isConfigured) {
                    var self = this,
                        getPatientListView = function () {
                            return new ListGenerator.PatientListView({
                                model: self.model.searches.get('patients'),
                                collection: self.model.searches.get('patients').get('patientCollection')
                            });
                        };

                    if (isConfigured) {
                        this.searchViews.patients = { patientList: getPatientListView };
                    }
                },
                _addClinicSearchView: function (isConfigured) {
                    var self = this,
                        getClinicListView = function() {
                            return new ListGenerator.ClinicListView({
                                model: self.model.searches.get('clinics'),
                                collection: self.model.searches.get('clinics').get('locationCollection')
                            });
                        };

                    if (isConfigured) {
                        this._addLocationSearchView('clinics', getClinicListView);
                    }
                },
                _addWardSearchView: function (isConfigured) {
                    var self = this,
                        getWardListView = function() {
                            return new ListGenerator.WardListView({
                                model: self.model.searches.get('wards'),
                                collection: self.model.searches.get('wards').get('locationCollection')
                            });
                        };

                    if (isConfigured) {
                        this._addLocationSearchView('wards', getWardListView);
                    }
                },
                _addLocationSearchView: function (location, getLocationListView, gplv) {
                    var self = this;

                    if ( typeof this.model.searches.get(location) !== 'undefined' && this.model.searches.get(location).has('locationCollection') ) {
                        this._addLocationSearchViewAndListeners(location, getLocationListView, gplv);
                    } else {
                        this.searchViews[location] = {
                            locationList: function() {
                                return new LoadingView();
                            }
                        };

                        ListGenerator.vent.once("load:" + location, function () {
                            self._addLocationSearchViewAndListeners(location, getLocationListView, gplv);
                            if ( self.model.get('searchType') === 'clinics' || self.model.get('searchType') === 'wards' || self.model.get('searchType') === 'wc-list') {
                                self.updateView();
                            }
                        });
                    }
                },
                _addLocationSearchViewAndListeners: function(location, getLocationListView, gplv) {
                    var self = this, getPatientListView;
                    if (gplv === undefined) {
                        getPatientListView = function() {
                            return new ListGenerator.PatientListView({
                                model: self.model.searches.get(location),
                                collection: self.model.searches.get(location).get('patientCollection'),
                                placeholder: "Filter Patient List...",
                                minLength: 0,
                                onSubmit: false
                            });
                        };
                    }
                    else {
                        getPatientListView = gplv;
                    }
                        

                    self.searchViews[location] = {
                        locationList: getLocationListView,
                        patientList: getPatientListView
                    };
                    this.listenTo(self.model.searches.get(location), 'change:location', function() {
                        self.model.searches.get(location).get('patientCollection').reset();

                        if (self.model.searches.get(location).get('location') === '') {
                            self.model.searches.get(location).set('patientFilter', "");
                        }
                        self.toggleSecondaryFilter(location);
                        if (self.model.searches.get(location).get('location') !== '') {
                            self.secondaryFilterRegion.$el.find('.ui-input-search input').focus();
                        }
                    });

                    if (location === 'clinics') {
                        this.listenTo(self.model.searches.get('clinics'), 'change:dateFilter', function() {
                            self.model.searches.get('clinics').get('patientCollection').reset();
                            self.toggleSecondaryFilter('clinics');
                        });
                    }
                },
                _addRecentPatientSearchView: function (isConfigured) {
                    var self = this,
                        getPatientListView = function() {
                            return new ListGenerator.RecentPatientListView({
                                model: self.model.searches.get('recent'),
                                collection: self.model.searches.get('recent').get('patientCollection')
                            });
                        };

                    if (isConfigured) {
                        if ( typeof this.model.searches.get('recent') !== 'undefined' && this.model.searches.get('recent').has('patientCollection') ) {
                            this.searchViews.recent = { patientList: getPatientListView };
                        } else {
                            this.searchViews.recent = { patientList: function() { return new LoadingView(); } };

                            ListGenerator.vent.once("load:recent", function () {
                                self.searchViews.recent = { patientList: getPatientListView };

                                if ( self.model.get('searchType') === 'recent' ) {
                                    self.updateView();
                                }
                            });
                        }
                    }
                }
            });
        }, template);
    });